<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ArticuloDestino extends Model 
{

    protected $table = 'articulo_destino';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function destino()
    {
        return $this->belongsTo('App\Models\Destino');
    }

    public function articulo()
    {
        return $this->belongsTo('App\Models\Articulo');
    }

    public function reponsable()
    {
        return $this->hasOne('App\Models\Responsable');
    }

}